/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.cc;

import com.tom.createores.Config;
import com.tom.createores.OreDataCapability;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ThreeState;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2960;

public class OreVeinFinderTurtle
extends AbstractTurtleUpgrade {
    protected OreVeinFinderTurtle(class_2960 id, class_1799 item) {
        super(id, TurtleUpgradeType.PERIPHERAL, item);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle);
    }

    public static class Peripheral
    implements IPeripheral {
        private final ITurtleAccess turtle;
        private AtomicLong time = new AtomicLong();

        public Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        public String getType() {
            return "coe_vein_finder";
        }

        public boolean equals(IPeripheral other) {
            return other instanceof Peripheral;
        }

        public Object getTarget() {
            return this.turtle;
        }

        @LuaFunction
        public final MethodResult search() throws LuaException {
            return this.turtle.executeCommand((TurtleCommand)new VeinFinderCommand(this.time));
        }

        @LuaFunction
        public final MethodResult getCooldown() throws LuaException {
            return this.turtle.executeCommand(new TurtleCommand(){

                public TurtleCommandResult execute(ITurtleAccess turtle) {
                    long t = turtle.getLevel().method_8510();
                    long dt = t - time.get();
                    long rem = Math.max(0L, (long)Config.veinFinderCd - dt);
                    return TurtleCommandResult.success((Object[])new Object[]{(double)rem});
                }
            });
        }
    }

    private static class VeinFinderCommand
    implements TurtleCommand {
        private AtomicLong time;

        public VeinFinderCommand(AtomicLong time) {
            this.time = time;
        }

        public TurtleCommandResult execute(ITurtleAccess turtle) {
            long time = turtle.getLevel().method_8510();
            if (time - this.time.get() < (long)Config.veinFinderCd) {
                return TurtleCommandResult.failure((String)"Ore Vein Finder on cooldown");
            }
            if (!turtle.getLevel().method_8320(turtle.getPosition().method_10074()).method_26234((class_1922)turtle.getLevel(), turtle.getPosition().method_10074())) {
                return TurtleCommandResult.failure((String)"Ore Vein Finder requires a full block below the turtle");
            }
            if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 5) {
                return TurtleCommandResult.failure((String)"Ouf of fuel");
            }
            class_1923 center = new class_1923(turtle.getPosition());
            OreDataCapability.OreData d = OreDataCapability.getData(turtle.getLevel().method_8497(center.field_9181, center.field_9180));
            ArrayList<Object> result = new ArrayList<Object>();
            class_1863 m = turtle.getLevel().method_8433();
            if (d != null) {
                VeinRecipe rec = d.getRecipe(m);
                result.add(rec != null);
                if (rec != null) {
                    result.add(rec.id.toString());
                    result.add(Double.valueOf(this.getVeinSize(d, rec)));
                }
            } else {
                result.add(false);
            }
            if (turtle.isFuelNeeded()) {
                turtle.consumeFuel(5);
            }
            this.time.set(time);
            return TurtleCommandResult.success((Object[])result.toArray());
        }

        private long getVeinSize(OreDataCapability.OreData d, VeinRecipe r) {
            if (r.isFinite() != ThreeState.NEVER) {
                if (r.isFinite() == ThreeState.DEFAULT && Config.defaultInfinite) {
                    return 0L;
                }
                double mul = (r.getMaxAmount() - r.getMinAmount()) * d.getRandomMul() + r.getMinAmount();
                long am = Math.round(mul * (double)Config.finiteAmountBase);
                return am;
            }
            return 0L;
        }
    }
}

